from fuzzywuzzy import fuzz, process

class AliasResolver:
    def __init__(self, api_client, threshold=85):
        self.api_client = api_client
        self.alias_store = {}
        self.threshold = threshold

    async def resolve(self, node, visited):
        if node in visited:
            return node

        if node in self.alias_store:
            return self.alias_store[node]

        candidates = process.extractBests(node, visited, scorer=fuzz.partial_ratio, score_cutoff=self.threshold)

        if candidates:
            question = f'Is "{node}" the same as any of these? {", ".join([c[0] for c in candidates])}\nAnswer "yes:entity" if so, otherwise "no".'
            response = await self.api_client.call("gpt-4o-mini-2024-07-18", question, for_graph=True)
            response = response.strip().lower()
            if response.startswith("yes:"):
                alias = response[4:].strip()
                self.alias_store[node] = alias
                return alias

        self.alias_store[node] = node
        return node
